//
//  Grouping_Tasks_Together_with_GCDAppDelegate.m
//  Grouping Tasks Together with GCD
//
//  Created by Vandad Nahavandipoor on 14/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Grouping_Tasks_Together_with_GCDAppDelegate.h"

void reloadAllComponents(void *context);

@implementation Grouping_Tasks_Together_with_GCDAppDelegate

@synthesize window = _window;

- (void) reloadTableView{
  /* Ponowne wczytanie widoku tabeli. */
  NSLog(@"%s", __FUNCTION__);
}

- (void) reloadScrollView{
  /* Wykonanie odpowiedniej operacji. */
  NSLog(@"%s", __FUNCTION__);
}

- (void) reloadImageView{
  /* Ponowne wczytanie widoku obrazu. */
  NSLog(@"%s", __FUNCTION__);
}

void reloadAllComponents(void *context){
  
  Grouping_Tasks_Together_with_GCDAppDelegate *self = 
    (__bridge Grouping_Tasks_Together_with_GCDAppDelegate *)context;
  
  [self reloadTableView];
  [self reloadScrollView];
  [self reloadImageView];
  
}

- (BOOL)              application:(UIApplication *)application 
    didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  dispatch_group_t taskGroup =  dispatch_group_create();
  dispatch_queue_t mainQueue =  dispatch_get_main_queue();
  
  dispatch_group_async_f(taskGroup, 
                         mainQueue, 
                         (__bridge void *)self, 
                         reloadAllComponents);
  
  /* Po zakończeniu wykonywania powyższych bloków zostanie uruchomiony poniższy blok. */
  dispatch_group_notify(taskGroup, mainQueue, ^{
    /* Przetwarzanie danych. */
    [[[UIAlertView alloc] initWithTitle:@"Gotowe"
                                message:@"Wszystkie zadania zostały ukończone"
                               delegate:nil 
                      cancelButtonTitle:@"OK"
                      otherButtonTitles:nil, nil] show];
    
  });
  
  /* Zakończyliśmy pracę z grupą. */
  dispatch_release(taskGroup);
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

//- (BOOL)            application:(UIApplication *)application
//  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
//  
//  dispatch_group_t taskGroup =  dispatch_group_create();
//  dispatch_queue_t mainQueue =  dispatch_get_main_queue();
//  
//  /* Ponowne wczytanie widoku tabeli w kolejce głównej. */
//  dispatch_group_async(taskGroup, mainQueue, ^{
//    [self reloadTableView];
//  });
//  
//  /* Ponowne wczytanie widoku przewijanego w kolejce głównej. */
//  dispatch_group_async(taskGroup, mainQueue, ^{
//    [self reloadScrollView];
//  });
//  
//  /* Ponowne wczytanie widoku obrazu w kolejce głównej. */
//  dispatch_group_async(taskGroup, mainQueue, ^{
//    [self reloadImageView];
//  });
//  
//  /* Po zakończeniu wykonywania powyższych bloków zostanie uruchomiony poniższy blok. */
//  dispatch_group_notify(taskGroup, mainQueue, ^{
//    /* Przetwarzanie danych. */
//    [[[UIAlertView alloc] initWithTitle:@"Gotowe"
//                                message:@"Wszystkie zadania zostały ukończone"
//                               delegate:nil 
//                      cancelButtonTitle:@"OK"
//                      otherButtonTitles:nil, nil] show];
//    
//  });
//  
//  /* Zakończyliśmy pracę z grupą. */
//  dispatch_release(taskGroup);
//  
//  self.window = [[UIWindow alloc] initWithFrame:
//                 [[UIScreen mainScreen] bounds]];
//  
//  self.window.backgroundColor = [UIColor whiteColor];
//  [self.window makeKeyAndVisible];
//  return YES;
//}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
